extern crate amethyst;

use amethyst::{Application, Duration, State, Trans};

struct HelloWorld;

impl State for HelloWorld {
    fn on_start(&mut self) {
        println!("Game started!");
    }

    fn update(&mut self, delta: Duration) -> Trans {
        println!("Hello from Amethyst!");
        Trans::Quit
    }

    fn on_stop(&mut self) {
        println!("Game stopped!");
    }
}

fn main() {
    let mut game = Application::new(HelloWorld);
    game.run();
}
